import logging

import boto3
import pytest

from ray._private.test_utils import simulate_storage
from ray.air._internal.uri_utils import URI

# Trigger pytest hook to automatically zip test cluster logs to archive dir on failure
from ray.tests.conftest import propagate_logs  # noqa
from ray.tests.conftest import pytest_runtest_makereport  # noqa


@pytest.fixture
def mock_s3_bucket_uri():
    port = 5002
    region = "us-west-2"
    with simulate_storage("s3", port=port, region=region) as s3_uri:
        s3 = boto3.client(
            "s3", region_name=region, endpoint_url=f"http://localhost:{port}"
        )
        # Bucket name will be autogenerated/unique per test
        bucket_name = URI(s3_uri).name
        s3.create_bucket(
            Bucket=bucket_name,
            CreateBucketConfiguration={"LocationConstraint": region},
        )
        # Disable server HTTP request logging
        logging.getLogger("werkzeug").setLevel(logging.WARNING)
        yield s3_uri
        logging.getLogger("werkzeug").setLevel(logging.INFO)
